/*
* Les URLs des fichiers WSDL de description des
* primitives du service de rservation.
*/
var RESERVATION_BOOK_WSDL_URL = 	"http://www.sw-voyages.com:9700/collaxa/default/SWVoyages_Reservation_Book/SWVoyages_Reservation_Book.wsdl";
var RESERVATION_CANCEL_WSDL_URL = 	"http://www.sw-voyages.com:9700/collaxa/default/SWVoyages_Reservation_Cancel/SWVoyages_Reservation_Cancel.wsdl";
var RESERVATION_GETAIR_WSDL_URL = 	"http://www.sw-voyages.com:9700/collaxa/default/SWVoyages_Reservation_GetAir/SWVoyages_Reservation_GetAir.wsdl";
var RESERVATION_GETCAR_WSDL_URL = 	"http://www.sw-voyages.com:9700/collaxa/default/SWVoyages_Reservation_GetCar/SWVoyages_Reservation_GetCar.wsdl";
var RESERVATION_GETHOTEL_WSDL_URL =	"http://www.sw-voyages.com:9700/collaxa/default/SWVoyages_Reservation_GetHotel/SWVoyages_Reservation_GetHotel.wsdl";
var RESERVATION_SEARCH_WSDL_URL = 	"http://www.sw-voyages.com:9700/collaxa/default/SWVoyages_Reservation_Search/SWVoyages_Reservation_Search.wsdl";

/*
* L'identifiant de rservation.
*/
var reservationId;

/*
* Renvoie l'identifiant de rservation.
*/
function getReservationId() {
	return reservationId;
}

/*
* Affecte l'identifiant de rservation.
*/
function setReservationId(id) {
	reservationId = id;
}

/*
* Horloges utilises pour l'mission des requtes de
* polling adresses au serveur.
*/
var timer1ID;
var timer2ID;
var timer3ID;
var timer4ID;
var timer5ID;
var timer6ID;

/*
* Identifiants des conversations inities par le client 
* lors de l'mission des requtes de polling adresses 
* au serveur.
*/
var conversation1ID;
var conversation2ID;
var conversation3ID;
var conversation4ID;
var conversation5ID;
var conversation6ID;

/*
* Renvoie l'intervalle (en millisecondes) entre les
* requtes de polling adresses au serveur, utilis
* par les horloges.
*/
function getDelay() {
	return 3000;
}

/*
* Renvoie l'chelle possible des n de conversation
* gnrs par le client lors de l'invocation des services
* du serveur (fonction random).
*/
function getScale() {
	return 1000000;
}

/*
* Renvoie le modle de la table HTML des disponibilits
* ariennes.
*/
var at;
function getAirTemplates() {
	if (at==null) {
		at = new Array(
			new Array(30,  "Choix", "ns1:id"),
			new Array(64,  "Date", null),
			new Array(100, "Compagnie", "ns1:airCompany"),
			new Array(54,  "N de vol", "ns1:flightNumber"),
			new Array(103, "Ville Dpart", "ns1:departureAirport"),
			new Array(50,  "H.Dpart", "ns1:departureHour"),
			new Array(50,  "H.Arrive", "ns1:arrivalHour"),
			new Array(102, "Ville Arrive", "ns1:arrivalAirport"),
			new Array(50,  "Prix", "ns1:price")
		);
	}
	return at;
}

/*
* Renvoie le modle de la table HTML des disponibilits
* automobiles.
*/
var ct;
function getCarTemplates() {
	if (ct==null) {
		ct = new Array(
			new Array(30,  "Choix", "ns1:id"),
			new Array(120, "Socit de location", "ns1:carRentalCompany"),
			new Array(54,  "Catgorie", "ns1:carCategory"),
			new Array(118, "Modle", "ns1:carModel"),
			new Array(50,  "J.Arrive", null),
			new Array(50,  "J.Dpart", null),
			new Array(50,  "Prix/semaine", "ns1:pricePerWeek"),
			new Array(50,  "Prix/jour", "ns1:pricePerDay")
		);
	}
	return ct;
}

/*
* Renvoie le modle de la table HTML des disponibilits
* htelires.
*/
var ht;
function getHotelTemplates() {
	if (ht==null) {
		ht =  new Array(
			new Array(30,  "Choix", "ns1:id"),
			new Array(120, "Chaine htelire", "ns1:hotelRentalCompany"),
			new Array(54,  "Htel", "ns1:hotelName"),
			new Array(118, "Adresse", "ns1:hotelLocation"),
			new Array(50,  "J.Arrive", null),
			new Array(50,  "J.Dpart", null),
			new Array(50,  "Prix minimum", "ns1:lowerPrice"),
			new Array(50,  "Prix maximum", "ns1:higherPrice")
		);
	}
	return ht;
}

/*
* Gre l'vnement de chargement de
* la fentre de rservation.
*/
function reservation_window_onload() {
	var today = new Date();
	var day = today.getDate();
	var month = today.getMonth();
	var year = today.getYear();
  
	search.disabled = true;

	// Alimente la list-box du jour de la date de dpart
	var i = 1;
	departure_day.options.remove(0);
	while (i < maximumDays(year, month)+1) {
  		var option = document.createElement("option");
		option.text=new Number(i).toString();
		option.value=i;
		departure_day.add(option, i);
		i++;
	}
	departure_day.selectedIndex=day-1;
	try {
		eval("departure_day_onchange()");
	}
	catch (e) {
	}

	// Alimente la list-box du jour de la date de retour
	var i = 1;
	arrival_day.options.remove(0);
	while (i < maximumDays(year, month)+1) {
  		var option = document.createElement("option");
		option.text=new Number(i).toString();
		option.value=i;
		arrival_day.add(option, i);
		i++;
	}
	arrival_day.selectedIndex=day-1;
	try {
		eval("arrival_day_onchange()");
	}
	catch (e) {
	}

	// Alimente la list-box du mois de la date de dpart
	var i = 1;
	departure_month.options.remove(0);
	while (i < 12+1) {
  		var option = document.createElement("option");
		option.text=monthAsString(i-1);
		option.value=i;
		departure_month.add(option, i);
		i++;
	}
	departure_month.selectedIndex=month;
	try {
		eval("departure_month_onchange()");
	}
	catch (e) {
	}

	// Alimente la list-box du mois de la date de retour
	var i = 1;
	arrival_month.options.remove(0);
	while (i < 12+1) {
  		var option = document.createElement("option");
		option.text=monthAsString(i-1);
		option.value=i;
		arrival_month.add(option, i);
		i++;
	}
	arrival_month.selectedIndex=month;
	try {
		eval("arrival_month_onchange()");
	}
	catch (e) {
	}

	// Alimente la list-box de l'anne de la date de dpart
	var i = year;
	departure_year.options.remove(0);
	while (i < year+2) {
  		var option = document.createElement("option");
		option.text=i;
		option.value=i;
		departure_year.add(option, i);
		i++;
	}
	departure_year.selectedIndex=0;
	try {
		eval("departure_year_onchange()");
	}
	catch (e) {
	}

	// Alimente la list-box de l'anne de la date de retour
	var i = year;
	arrival_year.options.remove(0);
	while (i < year+2) {
  		var option = document.createElement("option");
		option.text=i;
		option.value=i;
		arrival_year.add(option, i);
		i++;
	}
	arrival_year.selectedIndex=0;
	try {
		eval("arrival_year_onchange()");
	}
	catch (e) {
	}

	// Stoppe les ventuelles horloges actuellement
	// armes en cas de redmarrage de l'application
	// ( bouton refresh)
	if (timer1ID != null) {
		clearInterval(timer1ID);
		timer1ID = null;
	}
	if (timer2ID != null) {
		clearInterval(timer2ID);
		timer2ID = null;
	}
	if (timer3ID != null) {
		clearInterval(timer3ID);
		timer3ID = null;
	}
	if (timer4ID != null) {
		clearInterval(timer4ID);
		timer4ID = null;
	}
	if (timer5ID != null) {
		clearInterval(timer5ID);
		timer5ID = null;
	}
	if (timer6ID != null) {
		clearInterval(timer6ID);
		timer6ID = null;
	}

	window.status = "Localisation des services Web de rservation...";

	// Informe le comportement WebService Microsoft 
	// de la localisation des fichiers de description 
	// des services  utiliser (WSDL)
	service.useService(RESERVATION_BOOK_WSDL_URL,"ReservationBook");
	service.useService(RESERVATION_CANCEL_WSDL_URL,"ReservationCancel");
	service.useService(RESERVATION_GETAIR_WSDL_URL,"ReservationGetAir");
	service.useService(RESERVATION_GETCAR_WSDL_URL,"ReservationGetCar");
	service.useService(RESERVATION_GETHOTEL_WSDL_URL,"ReservationGetHotel");
	service.useService(RESERVATION_SEARCH_WSDL_URL,"ReservationSearch");
	service.showProgress=true;

	window.status = "Recherche de disponibilits accessible";
}

/*
* Gre l'vnement de chargement de
* la fentre des disponibilits.
*/
function availabilities_window_onload() {

	var information = "<p>Slectionnez vos critres de rservation SVP</p>";
	departureFlights.innerHTML = information;
	arrivalFlights.innerHTML = information;
	hotels.innerHTML = information;
	cars.innerHTML = information;

	cancel.disabled = true;
	book.disabled = true;

	window.status = "Recherche de disponibilits accessible";
}

/*
* Demande au serveur d'effectuer une nouvelle recherche
* de disponibilits. 
*/
function search_onclick() {
	window.status = "Recherche de disponibilits ...";

	var information = "<p>Slectionnez vos critres de rservation SVP</p>";
	parent.availabilities.departureFlights.innerHTML = information;
	parent.availabilities.arrivalFlights.innerHTML = information;
	parent.availabilities.hotels.innerHTML = information;
	parent.availabilities.cars.innerHTML = information;

	conversation1ID = randomize(getScale());
	try {
		var call = build_call_object("initiate", conversation1ID);
		var nodes = "<passengers>"+passengers.value+"</passengers><from>"+from.value+"</from><to>"+to.value+"</to>";
		nodes += "<roundTrip>"+roundtrip.value+"</roundTrip><departureDay>"+departure_day.value+"</departureDay>";
		nodes += "<departureMonth>"+departure_month.value+"</departureMonth><departureYear>"+departure_year.value+"</departureYear>"; 
		nodes += "<arrivalDay>"+arrival_day.value+"</arrivalDay><arrivalMonth>"+arrival_month.value+"</arrivalMonth>"; 
		nodes += "<arrivalYear>"+arrival_year.value+"</arrivalYear><hotelRequested>"+document.all.hotel.checked+"</hotelRequested>"; 
		nodes += "<carRequested>"+document.all.car.checked+"</carRequested>"; 
		call.params.xmlSearchRequest = nodes;
		service.ReservationSearch.callService(search_callback,call);
	}
	catch (e) {
		alert("erreur("+e.number+") : "+e.description);
	}
	window.status = "Recherche de disponibilits en cours...";
}

/*
* Gre la rponse du serveur  une nouvelle demande
* de recherche de disponibilits.
*
* @param		result le rsultat de l'appel SOAP
*/
function search_callback(result) {  
	if (soap_error(result)) {
		window.status = "Pas de disponibilits obtenues";
		return;
	}
	timer1ID=setInterval("search_pollResult('"+conversation1ID+"')", getDelay());
}

/*
* Interroge le serveur  intervalles rguliers afin
* de rcuprer la rponse  une prcdente demande de
* recherche de disponibilits.
*/
function search_pollResult(conversationID) {
	try {
		var call = build_call_object("pollResult", conversationID);
		service.ReservationSearch.callService(search_pollResult_callback,call);
	}
	catch (e) {
		alert("erreur("+e.number+") : "+e.description);
	}
}

/*
* Gre la rponse du serveur  une nouvelle demande
* de recherche de disponibilits.
*
* @param		result le rsultat de l'appel SOAP
*/
function search_pollResult_callback(result) { 
	if (pending_request(result)==true) {
		window.status = "En attente de disponibilits...";
		return;
	}
	if (soap_error(result)==true) {
		clearInterval(timer1ID);
		window.status = "Recherche de disponibilits stoppe";
		return;
	}
	setReservationId(result.value);
	clearInterval(timer1ID);

	try {
		var service = parent.reservation.service.ReservationGetAir;
		var reservationId = parent.reservation.getReservationId();
		conversation2ID = randomize(getScale());
		var call = build_call_object("initiate", conversation2ID);
		var node = "<reservationId>"+reservationId+"</reservationId>";
		call.params.xmlGetAirAvailabilitiesRequest = node;
		service.callService(get_airAvailabilities_callback,call);
		if (document.all.hotel.checked) {
			conversation3ID = randomize(getScale());
			call = build_call_object("initiate", conversation3ID);
			service = parent.reservation.service.ReservationGetHotel;
			call.params.xmlGetHotelAvailabilitiesRequest = node;
			service.callService(get_hotelAvailabilities_callback,call);
		}
		if (document.all.car.checked) {
			conversation4ID = randomize(getScale());
			call = build_call_object("initiate", conversation4ID);
			service = parent.reservation.service.ReservationGetCar;
			call.params.xmlGetCarAvailabilitiesRequest = node;
			service.callService(get_carAvailabilities_callback,call);
		}
	}
	catch (e) {
		alert("erreur("+e.number+") : "+e.description);
	}
	window.status = "Disponibilits obtenues";
}

/*
* Gre la rponse du serveur  une nouvelle demande
* de rcupration des disponibilits ariennes.
*
* @param		result le rsultat de l'appel SOAP
*/
function get_airAvailabilities_callback(result) {  
	if (soap_error(result)) {
		window.status = "Pas de disponibilits ariennes obtenues";
		return;
	}
	timer2ID=setInterval("get_airAvailabilities_pollResult('"+conversation2ID+"')", getDelay());
}

/*
* Interroge le serveur  intervalles rguliers afin
* de rcuprer la rponse  une prcdente demande de
* rcupration des disponibilits ariennes.
*/
function get_airAvailabilities_pollResult(conversationID) {
	try {
		var call = build_call_object("pollResult", conversationID);
		service.ReservationGetAir.callService(get_airAvailabilities_pollResult_callback,call);
	}
	catch (e) {
		alert("erreur("+e.number+") : "+e.description);
	}
}

/*
* Gre la rponse du serveur  une nouvelle demande
* de rcupration des disponibilits ariennes.
*
* @param		result le rsultat de l'appel SOAP
*/
function get_airAvailabilities_pollResult_callback(result) {  
	if (pending_request(result)==true) {
		window.status = "En attente de disponibilits ariennes...";
		return;
	}
	if (soap_error(result)==true) {
		clearInterval(timer2ID);
		window.status = "Recherche de disponibilits stoppe";
		return;
	}
	clearInterval(timer2ID);

	var availabilities = result.raw.getElementsByTagName("item");

	var information = "<p>Pas de disponibilits trouves selon vos critres de rservation</p>";
	if (roundtrip.value==0) {
		if (availabilities.length!=0) {
			getAirTemplates()[1][2] = departure_day.value + " " + monthAsString(departure_month.value-1);
			var information = build_availabilities(availabilities, getAirTemplates(), "departure_choice");
		}
		parent.availabilities.departureFlights.innerHTML = information;
	}
	else {
		var departure_availabilities = new Array();
		var arrival_availabilities = new Array();
		id = ia = 0;
		for (i = 0; i < availabilities.length; i++) {
			if (availabilities[i].getElementsByTagName("ns1:direction")[0].firstChild.nodeValue=="true") {
				departure_availabilities[id] = availabilities[i];
				id++;
			}
			else {
				arrival_availabilities[ia] = availabilities[i];
				ia++;
			}
		}
		if (departure_availabilities.length!=0) {
			getAirTemplates()[1][2] = departure_day.value + " " + monthAsString(departure_month.value-1);
			var information = build_availabilities(departure_availabilities, getAirTemplates(), "departure_choice");
		}
		parent.availabilities.departureFlights.innerHTML = information;
		information = "<p>Pas de disponibilits trouves selon vos critres de rservation</p>";
		if (departure_availabilities.length!=0) {
			getAirTemplates()[1][2] = arrival_day.value + " " + monthAsString(arrival_month.value-1);
			information = build_availabilities(arrival_availabilities, getAirTemplates(), "arrival_choice");
		}
		parent.availabilities.arrivalFlights.innerHTML = information;
	}
	switch_frame(parent.availabilities);
	
	window.status = "Disponibilits ariennes obtenues";
}

/*
* Gre la rponse du serveur  une nouvelle demande
* de rcupration des disponibilits htelires.
*
* @param		result le rsultat de l'appel SOAP
*/
function get_hotelAvailabilities_callback(result) {  
	if (soap_error(result)==true) {
		window.status = "Pas de disponibilits htelires obtenues";
		return;
	}
	timer3ID=setInterval("get_hotelAvailabilities_pollResult('"+conversation3ID+"')", getDelay());
}

/*
* Interroge le serveur  intervalles rguliers afin
* de rcuprer la rponse  une prcdente demande de
* rcupration des disponibilits htelires.
*/
function get_hotelAvailabilities_pollResult(conversationID) {
	try {
		var call = build_call_object("pollResult", conversationID);
		service.ReservationGetHotel.callService(get_hotelAvailabilities_pollResult_callback,call);
	}
	catch (e) {
		alert("erreur("+e.number+") : "+e.description);
	}
}

/*
* Gre la rponse du serveur  une nouvelle demande
* de rcupration des disponibilits htelires.
*
* @param		result le rsultat de l'appel SOAP
*/
function get_hotelAvailabilities_pollResult_callback(result) {  
	if (pending_request(result)==true) {
		window.status = "En attente de disponibilits htelires...";
		return;
	}
	if (soap_error(result)==true) {
		clearInterval(timer3ID);
		window.status = "Recherche de disponibilits stoppe";
		return;
	}
	clearInterval(timer3ID);

	var availabilities = result.raw.getElementsByTagName("item"); 

	var information = "<p>Pas de disponibilits trouves selon vos critres de rservation</p>";
	if (availabilities.length!=0) {
		getHotelTemplates()[4][2] = departure_day.value + " " + monthAsString(departure_month.value-1);
		getHotelTemplates()[5][2] = arrival_day.value + " " + monthAsString(arrival_month.value-1);
		var information = build_availabilities(availabilities, getHotelTemplates(), "hotel_choice");
	}
	parent.availabilities.hotels.innerHTML = information;

	switch_frame(parent.availabilities);

	window.status = "Disponibilits htelires obtenues";
}

/*
* Gre la rponse du serveur  une nouvelle demande
* de rcupration des disponibilits automobiles.
*
* @param		result le rsultat de l'appel SOAP
*/
function get_carAvailabilities_callback(result) {  
	if (soap_error(result)==true) {
		window.status = "Pas de disponibilits automobiles obtenues";
		return;
	}
	timer4ID=setInterval("get_carAvailabilities_pollResult('"+conversation4ID+"')", getDelay());
}

/*
* Interroge le serveur  intervalles rguliers afin
* de rcuprer la rponse  une prcdente demande de
* rcupration des disponibilits automobiles.
*/
function get_carAvailabilities_pollResult(conversationID) {
	try {
		var call = build_call_object("pollResult", conversationID);
		service.ReservationGetCar.callService(get_carAvailabilities_pollResult_callback,call);
	}
	catch (e) {
		alert("erreur("+e.number+") : "+e.description);
	}
}

/*
* Gre la rponse du serveur  une nouvelle demande
* de rcupration des disponibilits automobiles.
*
* @param		result le rsultat de l'appel SOAP
*/
function get_carAvailabilities_pollResult_callback(result) {  
	if (pending_request(result)==true) {
		window.status = "En attente de disponibilits automobiles...";
		return;
	}
	if (soap_error(result)==true) {
		clearInterval(timer4ID);
		window.status = "Recherche de disponibilits stoppe";
		return;
	}
	clearInterval(timer4ID);

	var availabilities = result.raw.getElementsByTagName("item"); 

	var information = "<p>Pas de disponibilits trouves selon vos critres de rservation</p>";
	if (availabilities.length!=0) {
		getCarTemplates()[4][2] = departure_day.value + " " + monthAsString(departure_month.value-1);
		getCarTemplates()[5][2] = arrival_day.value + " " + monthAsString(arrival_month.value-1);
		var information = build_availabilities(availabilities, getCarTemplates(), "car_choice");
	}
	parent.availabilities.cars.innerHTML = information;

	switch_frame(parent.availabilities);

	window.status = "Disponibilits automobiles obtenues";
}

/*
* Construit une table de disponibilits en fonction des
* disponibilits passes en paramtre et du modle de la
* table correspondante.
*
* @param		availabilities les disponibilits  afficher
* @param		templates le modle de la table des disponibilits
* @param		choice le nom du champ de slection de disponibilit
*/
function build_availabilities(availabilities, templates, choice) {  
	var string = "<table border=\"0\" cellspacing=\"1\" align=\"center\">\n";
	string = string +  "	<tr>\n"; 
	for (i = 0; i < templates.length; i++) {
		string = string +  "		<td width=\"" + templates[i][0] + "\"  align=\"center\" class=\"tdhead\">" + templates[i][1] + "</td>\n";
	}
	string = string +  "	</tr>\n";
	var checked = "checked";
	var styleClass = "tdeven";
	for (i = 0; i < availabilities.length; i++) {
		string = string +  "	<tr valign=\"middle\">\n"; 
		for (j = 0; j < templates.length; j++) {
			try {
				var value = eval("availabilities[i].getElementsByTagName(\""+templates[j][2]+"\")[0].firstChild.nodeValue");
			}
			catch (e) {
				var value = templates[j][2];
			}
			if (j==0) {
				string = string +  "		<td width=\"" + templates[j][0] + "\" align=\"center\" class=\"" + styleClass + "\">\n"; 
				string = string +  "			<input type=\"radio\" name=\"" + choice + "\" value=\"" + value + "\" " + checked + ">\n";
				string = string +  "		</td>\n";
			}
			else {
				string = string +  "		<td width=\"" + templates[j][0] + "\" align=\"center\" class=\"" + styleClass + "\">" + value + "</td>\n";
			}
		}
		string = string +  "	</tr>\n";
		if ((i % 2)==0) {
			styleClass = "tdodd";
		}
		else {
			styleClass = "tdeven";
		}
		checked = "";
	}
	string = string +  "</table>\n";
	return string
}

/*
* Demande au serveur d'effectuer une annulation de
* recherche de disponibilits. 
*/
function cancel_onclick() {
	try {
		conversation5ID = randomize(getScale());
		var call = build_call_object("initiate", conversation5ID);
		var node = "<reservationId>"+parent.reservation.getReservationId()+"</reservationId>";
		call.params.xmlCancelRequest = node;
		parent.reservation.service.ReservationCancel.callService(cancel_callback,call);
	}
	catch (e) {
		alert("erreur("+e.number+") : "+e.description);
	}
	window.status = "Annulation de rservation en cours...";
}

/*
* Gre la rponse du serveur  une demande
* d'annulation de recherche de disponibilits.
*
* @param		result le rsultat de l'appel SOAP
*/
function cancel_callback(result) {  
	if (soap_error(result) == true) {
		window.status = "Pas d'annulation de recherche de disponibilits obtenue";
		return;
	}
	timer5ID=setInterval("cancel_pollResult('"+conversation5ID+"')", getDelay());
}

/*
* Interroge le serveur  intervalles rguliers afin
* de rcuprer la rponse  une prcdente demande 
* d'annulation de recherche de disponibilits.
*/
function cancel_pollResult(conversationID) {
	try {
		var call = build_call_object("pollResult", conversationID);
		parent.reservation.service.ReservationCancel.callService(cancel_pollResult_callback,call);
	}
	catch (e) {
		alert("erreur("+e.number+") : "+e.description);
	}
}

/*
* Gre la rponse du serveur  une demande
* d'annulation de recherche de disponibilits.
*
* @param		result le rsultat de l'appel SOAP
*/
function cancel_pollResult_callback(result) {
	if (pending_request(result)==true) {
		window.status = "En attente d'annulation de recherche de disponibilits...";
		return;
	}
	if (soap_error(result)==true) {
		clearInterval(timer5ID);
		window.status = "Annulation de recherche de disponibilits stoppe";
		return;
	}
	if (result.raw.getElementsByTagName("ns1:result")[0].text=="") {
		clearInterval(timer5ID);
		window.status = "Annulation de recherche de disponibilits stoppe";
		return;
	}
	clearInterval(timer5ID);
	setReservationId(null);

	var information = "<p>Slectionnez vos critres de rservation SVP</p>";
	departureFlights.innerHTML = information;
	arrivalFlights.innerHTML = information;
	hotels.innerHTML = information;
	cars.innerHTML = information;

	switch_frame(parent.reservation);

	window.status = "Demande de disponibilits annule";
}

/*
* Demande au serveur d'effectuer une rservation des
* disponibilits slectionnes. 
*/
function book_onclick() {
	try {
		conversation6ID = randomize(getScale());
		var call = build_call_object("initiate", conversation6ID);
		var nodes = "<reservationId>"+parent.reservation.getReservationId()+"</reservationId>";
		nodes += "<departureChoice>"+get_selectedChoice_id("departure_choice")+"</departureChoice>";
		nodes += "<arrivalChoice>"+get_selectedChoice_id("arrival_choice")+"</arrivalChoice>";
		nodes += "<hotelChoice>"+get_selectedChoice_id("hotel_choice")+"</hotelChoice>";
		nodes += "<carChoice>"+get_selectedChoice_id("car_choice")+"</carChoice>";
		call.params.xmlBookRequest = nodes;
		parent.reservation.service.ReservationBook.callService(book_callback,call);
	}
	catch (e) {
		alert("erreur("+e.number+") : "+e.description);
	}
	window.status = "Rservation en cours...";
}

/*
* Gre la rponse du serveur  une demande
* de rservation de disponibilits.
*
* @param		result le rsultat de l'appel SOAP
*/
function book_callback(result) {  
	if (soap_error(result) == true) {
		window.status = "Pas de confirmation de rservation de disponibilits obtenue";
		return;
	}
	timer6ID=setInterval("book_pollResult('"+conversation6ID+"')", getDelay());
}

/*
* Interroge le serveur  intervalles rguliers afin
* de rcuprer la rponse  une prcdente demande de rservation 
* rservation de disponibilits.
*/
function book_pollResult(conversationID) {
	try {
		var call = build_call_object("pollResult", conversationID);
		parent.reservation.service.ReservationBook.callService(book_pollResult_callback,call);
	}
	catch (e) {
		alert("erreur("+e.number+") : "+e.description);
	}
}

/*
* Gre la rponse du serveur  une demande
* de rservation de disponibilits.
*
* @param		result le rsultat de l'appel SOAP
*/
function book_pollResult_callback(result) {
	if (pending_request(result)==true) {
		window.status = "En attente de confirmation de rservation de disponibilits...";
		return;
	}
	if (soap_error(result)==true) {
		clearInterval(timer6ID);
		window.status = "Confirmation de rservation de disponibilits stoppe";
		return;
	}
	if (result.raw.getElementsByTagName("ns1:result")[0].text=="") {
		clearInterval(timer6ID);
		window.status = "Confirmation de rservation de disponibilits stoppe";
		return;
	}
	clearInterval(timer6ID);

	switch_frame(parent.reservation);

	window.status = "Rservation effectue";

	var more = window.confirm("Votre rservation a t enregistre sous le n"+parent.reservation.getReservationId()
		+"\n( rappeler dans toute correspondance).\n\nVoulez-vous effectuer une autre rservation ?");
	setReservationId(null);
	if (more) { 
		return;
	}
	top.close();
}

/*
* Gre les requtes pendantes SOAP.
*
* @param		result le rsultat renvoy par la dernire
*				invocation SOAP
* @return		boolean renvoie "true" si le rsultat SOAP
*				correspond  une requte pendante.
*/
function pending_request(result) {  
    if (result.error) {
		var faultString = result.errorDetail.string;
		var faultCode = result.errorDetail.code;
//		alert(faultCode + " - " + faultString);  
		if ((faultCode=="ns1:Server.generalException" && 
		   	faultString.substring(0, 20)=="Request not finished") ||
			(faultString.length<20)) {
			return true;
		}
	}
	return false;
}

/*
* Gre les erreurs SOAP.
*
* @param		result le rsultat renvoy par la dernire
*				invocation SOAP
* @return		boolean renvoie "true" si une erreur SOAP
*				a t retourne  la suite de la dernire
*				invocation
*/
function soap_error(result) {  
//    alert(result.error); 
    if (result.error) {  
		if (pending_request(result)==true) {
			return false;
		}
		var faultCode = result.errorDetail.code;
		var faultString = result.errorDetail.string;    
		var errorString = faultCode + " - " + faultString;
		alert("A service error occurred : " + errorString);
		return true;
	}
	return false;
}

/*
* Construit l'objet d'invocation SOAP.
*
* @param		function la mthode du service Web qui doit
*				tre invoque 
* @param		header l'en-tte SOAP qui doit tre utilis
*				lors de l'invocation de la mthode 
* @return		object renvoie l'objet d'invocation SOAP
*				utilis lors de l'appel d'une mthode d'un
*				service Web
*/
function build_call_object(function, header) {  
	var call_object = new Object();
	call_object.funcName = function;
	call_object.SOAPHeader = new Array();
	call_object.SOAPHeader[0] = header;
	call_object.params = new Array();
	return call_object;
}

/*
* Commute les autorisations d'accs entre
* les deux cadres.
*/
function switch_frame(frame) {
	if (frame==parent.availabilities) {
		frame.cancel.disabled = false;
		frame.book.disabled = false;
		search.disabled = true;
	
		from.disabled = true;
		to.disabled = true;
		departure_day.disabled = true;
		departure_month.disabled = true;
		departure_year.disabled = true;
		arrival_day.disabled = true;
		arrival_month.disabled = true;
		arrival_year.disabled = true;
		roundtrip.disabled = true;
		passengers.disabled = true;
	
		hotel.disabled = true;
		car.disabled = true;
	}
	else {
		parent.availabilities.cancel.disabled = true;
		parent.availabilities.book.disabled = true;
		frame.search.disabled = false;

		frame.from.disabled = false;
		frame.to.disabled = false;
		frame.departure_day.disabled = false;
		frame.departure_month.disabled = false;
		frame.departure_year.disabled = false;
		frame.arrival_day.disabled = false;
		frame.arrival_month.disabled = false;
		frame.arrival_year.disabled = false;
		frame.roundtrip.disabled = false;
		frame.passengers.disabled = false;
	
		frame.hotel.disabled = false;
		frame.car.disabled = false;
	}
}

/*
* Gre la validation globale des modifications
* des caractristiques de rservation.
*/
function is_reservation_ok() {
	if (from.value=="") {
		search.disabled = true;
		return;
	}
	if (to.value=="") {
		search.disabled = true;
		return;
	}
	if (isNaN(parseInt(passengers.value, 10))) {
		search.disabled = true;
		return;
	}
	if (from.value==to.value) {
		search.disabled = true;
		return;
	}
	if (arrival_year.value<departure_year.value) {
		search.disabled = true;
		return;
	}
	if (arrival_year.value==departure_year.value &&
		parseInt(arrival_month.value, 10)<parseInt(departure_month.value, 10)) {
		search.disabled = true;
		return;
	}
	if (arrival_year.value==departure_year.value &&
		parseInt(arrival_month.value, 10)==parseInt(departure_month.value, 10) &&
		arrival_day.value<departure_day.value) {
		search.disabled = true;
		return;
	}
	search.disabled = false;
}

/*
* Gre la saisie de la localit de dpart.
*/
function from_onchange() {
	is_reservation_ok();
}

/*
* Gre la saisie de la localit d'arrive.
*/
function to_onchange() {
	is_reservation_ok();
}

/*
* Gre la saisie du jour de dpart.
*/
function departure_day_onchange() {
	departure_day.selectedIndex=departure_day.value-1;
	is_reservation_ok();
}

/*
* Gre la saisie du mois de dpart.
*/
function departure_month_onchange() {
	departure_month.selectedIndex=departure_month.value-1;
	update_departure_day_listbox();
	is_reservation_ok();
}

/*
* Gre la saisie de l'anne de dpart.
*/
function departure_year_onchange() {
	departure_year.selectedIndex=departure_year.value-new Date().getYear();
	update_departure_day_listbox();
	is_reservation_ok();
}

/*
* Gre la saisie du jour d'arrive.
*/
function arrival_day_onchange() {
	arrival_day.selectedIndex=arrival_day.value-1;
	is_reservation_ok();
}

/*
* Gre la saisie du mois d'arrive.
*/
function arrival_month_onchange() {
	arrival_month.selectedIndex=arrival_month.value-1;
	update_arrival_day_listbox();
	is_reservation_ok();
}

/*
* Gre la saisie de l'anne d'arrive.
*/
function arrival_year_onchange() {
	arrival_year.selectedIndex=arrival_year.value-new Date().getYear();
	update_arrival_day_listbox();
	is_reservation_ok();
}

/*
* Gre la saisie du type de voyage
* (Aller simple ou Aller retour).
*/
function roundtrip_onchange() {
	is_reservation_ok();
}

/*
* Gre la saisie du nombre de voyageurs.
*/
function passengers_onchange() {
	is_reservation_ok();
}

/*
* Actualise la list-box du jour de la date de dpart
* en fonction du mois et de l'anne slectionns.
*/
function update_departure_day_listbox() {
	var nbdays = maximumDays(departure_year.value, departure_month.value-1);
	if (nbdays==departure_day.options.length) {
		return;
	}
	if (nbdays - departure_day.options.length < 0) {
		while (nbdays - departure_day.options.length != 0) {
			var i = departure_day.options.length - 1;
			departure_day.options.remove(i);
		}
	}
	else {
		while (nbdays - departure_day.options.length != 0) {
 			var option = document.createElement("option");
			option.text=new Number(departure_day.options.length+1).toString();
			option.value=departure_day.options.length+1;
			departure_day.add(option, departure_day.options.length+1);
		}
	}
}

/*
* Actualise la list-box du jour de la date d'arrive
* en fonction du mois et de l'anne slectionns.
*/
function update_arrival_day_listbox() {
	var nbdays = maximumDays(arrival_year.value, arrival_month.value-1);
	if (nbdays==arrival_day.options.length) {
		return;
	}
	if (nbdays - arrival_day.options.length < 0) {
		while (nbdays - arrival_day.options.length != 0) {
			var i = arrival_day.options.length - 1;
			arrival_day.options.remove(i);
		}
	}
	else {
		while (nbdays - arrival_day.options.length != 0) {
 			var option = document.createElement("option");
			option.text=new Number(arrival_day.options.length+1).toString();
			option.value=arrival_day.options.length+1;
			arrival_day.add(option, arrival_day.options.length+1);
		}
	}
}

/*
* Renvoie l'identifiant de la disponibilit
* choisie.
*/
function get_selectedChoice_id(radioIds) {
	var choices = document.all.item(radioIds);
	if (choices==null || choices.length==0) {
		return 0;
	}
	for (i=0; i<choices.length; i++) {
		var choice = document.all.item(radioIds,i)
		if (choice.checked) {
			return choice.value;
		}
	}
}

/*
* Gre l'vnement de dchargement de
* la fentre de rservation.
*/
function reservation_window_onunload() {
	if (parent.reservation.getReservationId()!=null) {
		try {
			var node = "<reservationId>"+parent.reservation.getReservationId()+"</reservationId>";
			service.ReservationCancel.callService(cancel_callback,"initiateReservationService_Cancel",node);
		}
		catch (e) {
			alert("erreur("+e.number+") : "+e.description);
		}
	}
	window.status = "";
}

/*
* Gre l'vnement d'imminence de dchargement 
* de la fentre de rservation. Protge l'utilisateur
* contre une sortie non dsire de l'application.
*/
function reservation_window_onbeforeunload() {
	window.event.returnValue = "Abandonner la rservation en cours ?";
}

/*
* Renvoie le nombre de jours maximum d'un
* mois donn pour une anne donne.
*/
var days;
function maximumDays(year, month) {
	if (days==null) {
		days = new Array(31,28,31,30,31,30,31,31,30,31,30,31);
	}
	if (month!=1) {
		return days[month];
	}
	if (((year % 4 == 0) && (year % 100 != 0)) || (year % 400 == 0)) {
		return 29;
	}
	return 28
}

/*
* Renvoie le mois pass en paramtre sous
* forme d'une chane de caractres.
*/
var months;
function monthAsString(month) {
	if (months==null) {
		months = new Array("Janvier","Fvrier","Mars","Avril","Mai","Juin",
			"Juillet","Aot","Septembre","Octobre","Novembre","Dcembre");
	}
	return months[month];
}

/*
* Renvoie un entier pseudo-alatoire, multipli par
* le facteur pass en paramtre. La valeur gnre
* renvoye est comprise dans l'intervalle 0*factor
* et 1*factor inclus (idalement, il serait plutt
* intressant que cette mthode renvoie un identifiant
* de type GUID ou UUID). 
*/
function randomize(factor) {
	return Math.round(Math.random()*factor);
}